/**
* \file: VirtualSensorSource.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: M. Adachi / ADIT/SW / madachi@jp.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef AAUTO_VIRTUAL_SENSORSOURCE_H
#define AAUTO_VIRTUAL_SENSORSOURCE_H

#include <string>
#include <list>
#include <atomic>
#include <unistd.h>
#include <sys/prctl.h>
#include <sys/time.h>
#include <pthread_adit.h>
#include <aauto/common.h>
#include <aauto/MessageRouter.h>
#include <aauto/SensorSource.h>
#include <aauto/util/Mutex.h>

namespace adit { namespace aauto {

#define     SData_1e6   1000000
#define     SData_1e3   1000

enum sensorTestMode 
{
    aautoSensorWork         = 0x01,
    aautoSensorStop         = 0x02,
    aautoSensorEndlessWork  = 0x81,
    aautoSensorBreak        = 0x82
};

typedef struct SensorTableType
{
    std::string cfgstr;
    SensorType  type;
    uint32_t    interval_ms;
    int32_t     testCount;
}sensorTable, *p_sensorTable;

class SensorTest
{
public:
    SensorTest(bool inVerbose, sensorTable& inSensor);
    virtual ~SensorTest(){ };

    int start(::shared_ptr<SensorSource> inSensorSource);
    SensorType getType()
    {
        return  sensor.type;
    };
    void setMode(sensorTestMode mode);

protected:
    bool verbose;
    ::shared_ptr<SensorSource> sensorSource;
    sensorTable sensor;
    int testCount;
    int remainingTime;
    sensorTestMode testMode;

private:
    virtual int ExecTest(sensorTestMode& testMode) = 0;
    Mutex mLock;
};

class VirtualSensorSource
{
public:
    VirtualSensorSource(uint8_t inSessionId, MessageRouter* inMessageRouter, uint32_t inLocationCharacterization);
    ~VirtualSensorSource();
    bool init();
    int start();
    void stop();
    void setConfigItem(std::string inKey, std::string inValue);
    void setMode(SensorType type, sensorTestMode mode);
    ::shared_ptr<SensorSource> sensor;

private:
    std::string testLocate;
    bool StartThread();
    void StopThread();
    static void* sensorThread(void* inData);

    bool prepareTest();
    void getAdjustTime();
    void autoAdjustTime();
    void wait_us(uint32_t usec);
    bool SensorTestExec();
    bool SetSensorType();
    int64_t getConfig(const std::string& key, int64_t defaultValue) const;
    std::string getConfig(const std::string& key, std::string defaultValue) const;

    std::atomic<bool> threadRunning;
    bool verbose;
    uint32_t loopTime;
    uint32_t previousTime;
    pthread_t threadId;
    ::shared_ptr<SensorSource> sensorSource;
    std::list<::shared_ptr<SensorTest>> sensorTests;
    std::list<sensorTable> sensorList;
    std::map<std::string, std::string> config;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_VIRTUAL_SENSORSOURCE_H */
